/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    interface IDyedBuffer {
        abstract getColor(): Internal.DyeColor;
        get color(): Internal.DyeColor
        (): Internal.DyeColor_;
    }
    type IDyedBuffer_ = IDyedBuffer;
    interface BooleanSupplier {
        abstract getAsBoolean(): boolean;
        get asBoolean(): boolean
        (): boolean;
    }
    type BooleanSupplier_ = BooleanSupplier;
    /**
     * Invoked when a block is placed.
    */
    class BlockPlacedEventJS extends Internal.EntityEventJS {
        constructor(entity: Internal.Entity_, level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_)
        /**
         * The block that is placed.
        */
        getBlock(): Internal.BlockContainerJS;
        /**
         * The block that is placed.
        */
        get block(): Internal.BlockContainerJS
    }
    type BlockPlacedEventJS_ = BlockPlacedEventJS;
    class ReportedEntity {
        constructor(arg0: Internal.UUID_)
        profileId: Internal.UUID;
    }
    type ReportedEntity_ = ReportedEntity;
    class CursorAdapter {
        static ofWindow(window: com.mojang.blaze3d.platform.Window_): Internal.CursorAdapter;
        applyStyle(style: Internal.CursorStyle_): void;
        static ofClientWindow(): Internal.CursorAdapter;
        dispose(): void;
        static ofWindow(windowHandle: number): Internal.CursorAdapter;
    }
    type CursorAdapter_ = CursorAdapter;
    class ChainDriveBlock extends Internal.RotatedPillarKineticBlock implements Internal.WeakPowerCheckingBlock, Internal.IBE<Internal.KineticBlockEntity>, Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static areBlocksConnected(state: Internal.BlockState_, other: Internal.BlockState_, facing: Internal.Direction_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.KineticBlockEntity>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.KineticBlockEntity;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.KineticBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        getBlockEntityClass(): typeof Internal.KineticBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.KineticBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static getRotationSpeedModifier(from: Internal.KineticBlockEntity_, to: Internal.KineticBlockEntity_): number;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityClass(): typeof Internal.KineticBlockEntity
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly PART: Internal.Property<Internal.ChainDriveBlock$Part>;
        static readonly CONNECTED_ALONG_FIRST_COORDINATE: Internal.BooleanProperty;
    }
    type ChainDriveBlock_ = ChainDriveBlock;
    interface IModifiable extends Internal.ItemLike {
        emi(amount: number): Internal.EmiStack;
        setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        abstract getToolDefinition(): Internal.ToolDefinition;
        abstract asItem(): Internal.Item;
        emi(): Internal.EmiStack;
        get toolDefinition(): Internal.ToolDefinition
        readonly SHINY: ResourceLocation;
        readonly DEFER_OFFHAND: ResourceLocation;
        readonly INDESTRUCTIBLE_ENTITY: ResourceLocation;
        readonly NO_INTERACTION: ResourceLocation;
        /**
         * @deprecated
        */
        readonly FAST_USE_ITEM: ResourceLocation;
        readonly RARITY: ResourceLocation;
    }
    type IModifiable_ = IModifiable;
    interface ComponentPath {
        path($$0: Internal.ContainerEventHandler_, $$1: Internal.ComponentPath_): this;
        leaf($$0: Internal.GuiEventListener_): this;
        abstract applyFocus(arg0: boolean): void;
        abstract component(): Internal.GuiEventListener;
        path($$0: Internal.GuiEventListener_, ...$$1: Internal.ContainerEventHandler_[]): this;
    }
    type ComponentPath_ = ComponentPath;
    class UseAnim extends Internal.Enum<Internal.UseAnim> {
        static values(): Internal.UseAnim[];
        static valueOf($$0: string): Internal.UseAnim;
        static readonly BRUSH: Internal.UseAnim;
        static readonly TOOT_HORN: Internal.UseAnim;
        static readonly BOW: Internal.UseAnim;
        static readonly NONE: Internal.UseAnim;
        static readonly EAT: Internal.UseAnim;
        static readonly DRINK: Internal.UseAnim;
        static readonly BLOCK: Internal.UseAnim;
        static readonly SPYGLASS: Internal.UseAnim;
        static readonly SPEAR: Internal.UseAnim;
        static readonly CROSSBOW: Internal.UseAnim;
    }
    type UseAnim_ = "toot_horn" | "spear" | "eat" | "block" | UseAnim | "brush" | "crossbow" | "spyglass" | "bow" | "drink" | "none";
    class ElectrumAmulet extends Internal.Item {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ElectrumAmulet_ = ElectrumAmulet;
    class LampPostItem extends Internal.BaseBlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type LampPostItem_ = LampPostItem;
    abstract class AgeableListModel <E extends Internal.Entity> extends Internal.EntityModel<E> implements com.simibubi.create.foundation.mixin.accessor.AgeableListModelAccessor, Internal.AgeableListModelAccessor {
        porting_lib$scaleHead(): boolean;
        create$callHeadParts(): Internal.Iterable<any>;
        porting_lib$bodyYOffset(): number;
        porting_lib$babyYHeadOffset(): number;
        getBabyYHeadOffset(): number;
        getBabyZHeadOffset(): number;
        getScaleHead(): boolean;
        porting_lib$babyHeadScale(): number;
        porting_lib$babyZHeadOffset(): number;
        create$callBodyParts(): Internal.Iterable<any>;
        porting_lib$babyBodyScale(): number;
        getBabyHeadScale(): number;
        get babyYHeadOffset(): number
        get babyZHeadOffset(): number
        get scaleHead(): boolean
        get babyHeadScale(): number
        readonly babyZHeadOffset: number;
        readonly babyBodyScale: number;
        readonly babyYHeadOffset: number;
        readonly babyHeadScale: number;
        readonly bodyYOffset: number;
        readonly scaleHead: boolean;
    }
    type AgeableListModel_<E extends Internal.Entity> = AgeableListModel<E>;
    class PalmTreeFeature extends Internal.BOPTreeFeature<Internal.PalmTreeConfiguration> {
        constructor(codec: Internal.Codec_<Internal.PalmTreeConfiguration>)
        checkSpace(world: Internal.LevelAccessor_, pos: BlockPos_, height: number, radius: number): boolean;
        generateLeavesTop(world: Internal.LevelAccessor_, pos: BlockPos_, maxRadius: number, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.PalmTreeConfiguration_): void;
    }
    type PalmTreeFeature_ = PalmTreeFeature;
    abstract class BaseImmutableMultimap <K, V> extends Internal.AbstractMultimap<K, V> {
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
    }
    type BaseImmutableMultimap_<K, V> = BaseImmutableMultimap<K, V>;
    class BlockStateRotateCallbackJS extends Internal.BlockStateModifyCallbackJS {
        constructor(state: Internal.BlockState_, rotation: Internal.Rotation_)
        /**
         * Rotates the specified direction
        */
        rotate(dir: Internal.Direction_): Internal.Direction;
        /**
         * Get the Rotation that this block is being rotated by
        */
        getRotation(): Internal.Rotation;
        /**
         * Get the Rotation that this block is being rotated by
        */
        get rotation(): Internal.Rotation
    }
    type BlockStateRotateCallbackJS_ = BlockStateRotateCallbackJS;
    class SmallBrownMushroomFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type SmallBrownMushroomFeature_ = SmallBrownMushroomFeature;
    class ScrollValueBehaviour extends Internal.BlockEntityBehaviour implements Internal.ValueSettingsBehaviour {
        constructor(label: net.minecraft.network.chat.Component_, be: Internal.SmartBlockEntity_, slot: Internal.ValueBoxTransform_)
        setValue(value: number): void;
        getClipboardKey(): string;
        isActive(): boolean;
        withClientCallback(valueCallback: Internal.Consumer_<number>): this;
        onlyActiveWhen(condition: Internal.Supplier_<boolean>): this;
        mayInteract(player: Internal.Player_): boolean;
        bypassesInput(mainhandItem: Internal.ItemStack_): boolean;
        onShortInteract(player: Internal.Player_, hand: Internal.InteractionHand_, side: Internal.Direction_, hitResult: Internal.BlockHitResult_): void;
        testHit(hit: Vec3d_): boolean;
        acceptsValueSettings(): boolean;
        requiresWrench(): this;
        getValue(): number;
        writeToClipboard(tag: Internal.CompoundTag_, side: Internal.Direction_): boolean;
        withFormatter(formatter: Internal.Function_<number, string>): this;
        getValueSettings(): Internal.ValueSettingsBehaviour$ValueSettings;
        setLabel(label: net.minecraft.network.chat.Component_): void;
        onlyVisibleWithWrench(): boolean;
        netId(): number;
        between(min: number, max: number): this;
        formatValue(): string;
        setValueSettings(player: Internal.Player_, valueSetting: Internal.ValueSettingsBehaviour$ValueSettings_, ctrlDown: boolean): void;
        playFeedbackSound(origin: Internal.BlockEntityBehaviour_): void;
        getSlotPositioning(): Internal.ValueBoxTransform;
        readFromClipboard(tag: Internal.CompoundTag_, player: Internal.Player_, side: Internal.Direction_, simulate: boolean): boolean;
        createBoard(player: Internal.Player_, hitResult: Internal.BlockHitResult_): Internal.ValueSettingsBoard;
        withCallback(valueCallback: Internal.Consumer_<number>): this;
        newSettingHovered(valueSetting: Internal.ValueSettingsBehaviour$ValueSettings_): void;
        set value(value: number)
        get clipboardKey(): string
        get active(): boolean
        get value(): number
        get valueSettings(): Internal.ValueSettingsBehaviour$ValueSettings
        set label(label: net.minecraft.network.chat.Component_)
        get slotPositioning(): Internal.ValueBoxTransform
        static readonly TYPE: Internal.BehaviourType<Internal.ScrollValueBehaviour>;
        value: number;
        label: net.minecraft.network.chat.Component;
    }
    type ScrollValueBehaviour_ = ScrollValueBehaviour;
    interface TextureAtlasSprite$Ticker extends Internal.AutoCloseable {
        abstract close(): void;
        abstract tickAndUpload(): void;
    }
    type TextureAtlasSprite$Ticker_ = TextureAtlasSprite$Ticker;
    abstract class BaseAuthenticationService implements Internal.AuthenticationService {
        constructor()
        abstract createProfileRepository(): Internal.GameProfileRepository;
        abstract createMinecraftSessionService(): Internal.MinecraftSessionService;
        abstract createUserAuthentication(arg0: Internal.Agent_): Internal.UserAuthentication;
    }
    type BaseAuthenticationService_ = BaseAuthenticationService;
    class PumpUpgradeConfig {
        constructor(builder: Internal.ForgeConfigSpec$Builder_)
        readonly filterSlots: Internal.ForgeConfigSpec$IntValue;
        readonly stackMultiplierRatio: Internal.ForgeConfigSpec$DoubleValue;
        readonly maxInputOutput: Internal.ForgeConfigSpec$IntValue;
    }
    type PumpUpgradeConfig_ = PumpUpgradeConfig;
    interface Nameable {
        getDisplayName(): net.minecraft.network.chat.Component;
        abstract getName(): net.minecraft.network.chat.Component;
        hasCustomName(): boolean;
        getCustomName(): net.minecraft.network.chat.Component;
        get displayName(): net.minecraft.network.chat.Component
        get name(): net.minecraft.network.chat.Component
        get customName(): net.minecraft.network.chat.Component
        (): net.minecraft.network.chat.Component_;
    }
    type Nameable_ = Nameable;
    class AllFanProcessingTypes$SplashingType implements Internal.FanProcessingType {
        constructor()
        canProcess(stack: Internal.ItemStack_, level: Internal.Level_): boolean;
        getPriority(): number;
        morphAirFlow(particleAccess: Internal.FanProcessingType$AirFlowParticleAccess_, random: Internal.RandomSource_): void;
        isValidAt(level: Internal.Level_, pos: BlockPos_): boolean;
        static getAt(level: Internal.Level_, pos: BlockPos_): Internal.FanProcessingType;
        process(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemStack>;
        static parse(str: string): Internal.FanProcessingType;
        affectEntity(entity: Internal.Entity_, level: Internal.Level_): void;
        spawnProcessingParticles(level: Internal.Level_, pos: Vec3d_): void;
        get priority(): number
    }
    type AllFanProcessingTypes$SplashingType_ = AllFanProcessingTypes$SplashingType;
    interface BotariumEnergyItem <T extends Internal.EnergyContainer & Internal.Updatable<Internal.ItemStack>> {
        abstract getEnergyStorage(arg0: Internal.ItemStack_): T;
        (arg0: Internal.ItemStack): T;
    }
    type BotariumEnergyItem_<T extends Internal.EnergyContainer & Internal.Updatable<Internal.ItemStack>> = BotariumEnergyItem<T>;
    class UntouchingEnchantment extends Internal.Enchantment {
        method_8180($$0: Internal.Enchantment_): boolean;
    }
    type UntouchingEnchantment_ = UntouchingEnchantment;
    class AnchorbladeEntity extends Internal.AbstractArrow {
        constructor(world: Internal.Level_, owner: Internal.LivingEntity_, stack: Internal.ItemStack_)
        constructor(entityType: Internal.EntityType_<Internal.AnchorbladeEntity>, world: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        setReeling(reeling: boolean): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        setItem(stack: Internal.ItemStack_): void;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        hasDealtDamage(): boolean;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setDealtDamage(dealtDamage: boolean): void;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setRecalled(recalled: boolean): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        isRecalled(): boolean;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        getStack(): Internal.ItemStack;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        hasReeling(): boolean;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        set reeling(reeling: boolean)
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        set item(stack: Internal.ItemStack_)
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        set dealtDamage(dealtDamage: boolean)
        get server(): Internal.MinecraftServer
        set recalled(recalled: boolean)
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get recalled(): boolean
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        get stack(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        returnTimer: number;
    }
    type AnchorbladeEntity_ = AnchorbladeEntity;
    abstract class AbstractReadStateHolder {
        constructor()
        getReadState(): Internal.EntryDisplayState;
        markReadStateDirty(): void;
        static mostImportantState(stream: Internal.Stream_<Internal.EntryDisplayState>): Internal.EntryDisplayState;
        get readState(): Internal.EntryDisplayState
    }
    type AbstractReadStateHolder_ = AbstractReadStateHolder;
    interface Constant <T extends Internal.Constant<T>> extends Internal.Comparable<T> {
        abstract name(): string;
        abstract compareTo(arg0: T): number;
        abstract id(): number;
    }
    type Constant_<T extends Internal.Constant<T>> = Constant<T>;
    interface ComputerEnvironment {
        abstract getMetrics(): Internal.MetricsObserver;
        abstract getDay(): number;
        abstract createRootMount(): Internal.WritableMount;
        abstract getTimeOfDay(): number;
        get metrics(): Internal.MetricsObserver
        get day(): number
        get timeOfDay(): number
    }
    type ComputerEnvironment_ = ComputerEnvironment;
    class PropertyComment extends Internal.AbstractProperty<Internal.PropertyComment> {
        constructor()
        constructor(...lines: string[])
        merge(other: Internal.PropertyComment_): this;
        merge(arg0: Internal.AbstractDocumentBase_<any>): Internal.AbstractDocumentBase<any>;
        copy(): Internal.AbstractDocumentBase<any>;
        add(line: string): this;
        isEmpty(): boolean;
        getLines(): Internal.List<string>;
        formatLines(indent: number): Internal.List<string>;
        get empty(): boolean
        get lines(): Internal.List<string>
    }
    type PropertyComment_ = PropertyComment;
    interface CustomFrictionBlock {
        abstract getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        (arg0: Internal.BlockState, arg1: Internal.LevelReader, arg2: BlockPos, arg3: Internal.Entity): number;
    }
    type CustomFrictionBlock_ = CustomFrictionBlock;
    class FluidRecipeWrapper implements net.minecraft.world.Container {
        constructor(fluid: Internal.FluidStack_)
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        static tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        removeItem(p_70298_1_: number, p_70298_2_: number): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        setItem(p_70299_1_: number, p_70299_2_: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        removeItemNoUpdate(p_70304_1_: number): Internal.ItemStack;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        stillValid(p_70300_1_: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        getItem(p_70301_1_: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get slots(): number
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        fluid: Internal.FluidStack;
    }
    type FluidRecipeWrapper_ = FluidRecipeWrapper;
    interface CustomIngredientMixin extends Internal.CustomIngredientKJS {
        kjs$canBeUsedForMatching(): boolean;
    }
    type CustomIngredientMixin_ = CustomIngredientMixin;
    class WeatheringCopperSlabBlock extends Internal.SlabBlock implements Internal.WeatheringCopper {
        constructor($$0: Internal.WeatheringCopper$WeatherState_, $$1: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        applyChangeOverTime($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getAge(): Internal.WeatheringCopper$WeatherState;
        getNext($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        static getPrevious($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        onRandomTick($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static getPrevious($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getAge(): Internal.Enum<any>;
        setDestroySpeed(v: number): void;
        static getFirst($$0: Internal.Block_): Internal.Block;
        static getNext($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getFirst($$0: Internal.BlockState_): Internal.BlockState;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getChanceModifier(): number;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get age(): Internal.WeatheringCopper$WeatherState
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get age(): Internal.Enum<any>
        set destroySpeed(v: number)
        get chanceModifier(): number
    }
    type WeatheringCopperSlabBlock_ = WeatheringCopperSlabBlock;
    class FluidParticleData implements Internal.ParticleOptions {
        constructor(type: Internal.ParticleType_<Internal.FluidParticleData>, fluid: Internal.FluidStack_)
        getType(): Internal.ParticleType<Internal.FluidParticleData>;
        getFluid(): Internal.FluidStack;
        writeToString(): string;
        writeToNetwork(buffer: Internal.FriendlyByteBuf_): void;
        get type(): Internal.ParticleType<Internal.FluidParticleData>
        get fluid(): Internal.FluidStack
    }
    type FluidParticleData_ = FluidParticleData;
    /**
     * @deprecated
    */
    interface RenderAttachmentBlockEntity {
        /**
         * @deprecated
        */
        abstract getRenderAttachmentData(): any;
        /**
         * @deprecated
        */
        get renderAttachmentData(): any
        (): any;
    }
    type RenderAttachmentBlockEntity_ = RenderAttachmentBlockEntity;
    interface TypeDescriptor$OfField <F extends Internal.TypeDescriptor$OfField<F>> extends Internal.TypeDescriptor {
        abstract isPrimitive(): boolean;
        abstract isArray(): boolean;
        abstract descriptorString(): string;
        abstract arrayType(): F;
        abstract componentType(): F;
        get primitive(): boolean
        get array(): boolean
    }
    type TypeDescriptor$OfField_<F extends Internal.TypeDescriptor$OfField<F>> = TypeDescriptor$OfField<F>;
    abstract class SpellList implements Internal.KMappedMarker, Internal.Iterable<Internal.Iota> {
        constructor($constructor_marker: any_)
        modifyAt(startIdx: number, modify: Internal.Function1_<Internal.SpellList, Internal.SpellList>): this;
        size(): number;
        spliterator(): Internal.Spliterator<Internal.Iota>;
        abstract getCdr(): this;
        iterator(): Internal.SpellList$SpellListIterator;
        abstract getNonEmpty(): boolean;
        abstract getCar(): Internal.Iota;
        getAt(startIdx: number): Internal.Iota;
        forEach(arg0: Internal.Consumer_<Internal.Iota>): void;
        get cdr(): Internal.SpellList
        get nonEmpty(): boolean
        get car(): Internal.Iota
    }
    type SpellList_ = SpellList;
    class Component$DismountReason extends Internal.Enum<Internal.Component$DismountReason> {
        static valueOf(name: string): Internal.Component$DismountReason;
        static values(): Internal.Component$DismountReason[];
        static readonly REMOVED: Internal.Component$DismountReason;
        static readonly LAYOUT_INFLATION: Internal.Component$DismountReason;
    }
    type Component$DismountReason_ = "removed" | "layout_inflation" | Component$DismountReason;
    abstract class AENetworkPowerBlockEntity extends Internal.AEBasePoweredBlockEntity implements Internal.IGridConnectedBlockEntity {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        onChunkUnloaded(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onMainNodeStateChanged(reason: Internal.IGridNodeListener$State_): void;
        onLoad(): void;
        getMainNode(): Internal.IManagedGridNode;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getCableConnectionType(dir: Internal.Direction_): Internal.AECableType;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getPriority(): number;
        getGridConnectableSides(orientation: Internal.BlockOrientation_): Internal.Set<Internal.Direction>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get mainNode(): Internal.IManagedGridNode
        get gridNode(): Internal.IGridNode
        get actionableNode(): Internal.IGridNode
        get priority(): number
        set owner(owner: Internal.Player_)
    }
    type AENetworkPowerBlockEntity_ = AENetworkPowerBlockEntity;
    class PoiRecord {
        constructor($$0: BlockPos_, $$1: Internal.Holder_<Internal.PoiType>, $$2: Internal.Runnable_)
        getPos(): BlockPos;
        hasSpace(): boolean;
        isOccupied(): boolean;
        /**
         * @deprecated
        */
        getFreeTickets(): number;
        getPoiType(): Internal.Holder<Internal.PoiType>;
        static codec($$0: Internal.Runnable_): Internal.Codec<Internal.PoiRecord>;
        get pos(): BlockPos
        get occupied(): boolean
        /**
         * @deprecated
        */
        get freeTickets(): number
        get poiType(): Internal.Holder<Internal.PoiType>
    }
    type PoiRecord_ = PoiRecord;
    class AWTKeyStroke implements Internal.Serializable {
        getKeyCode(): number;
        static getAWTKeyStroke(arg0: string): Internal.AWTKeyStroke;
        isOnKeyRelease(): boolean;
        static getAWTKeyStroke(arg0: string): Internal.AWTKeyStroke;
        getModifiers(): number;
        static getAWTKeyStroke(arg0: number, arg1: number): Internal.AWTKeyStroke;
        getKeyChar(): string;
        getKeyEventType(): number;
        static getAWTKeyStroke(arg0: number, arg1: number, arg2: boolean): Internal.AWTKeyStroke;
        static getAWTKeyStrokeForEvent(arg0: Internal.KeyEvent_): Internal.AWTKeyStroke;
        static getAWTKeyStroke(arg0: string, arg1: number): Internal.AWTKeyStroke;
        get keyCode(): number
        get onKeyRelease(): boolean
        get modifiers(): number
        get keyChar(): string
        get keyEventType(): number
    }
    type AWTKeyStroke_ = AWTKeyStroke;
    abstract class SectionedEntityMovementTracker <E extends Internal.EntityAccess, S> {
        constructor(interactionChunks: Internal.WorldSectionBox_, clazz: S)
        register(world: Internal.ServerLevel_): void;
        unRegister(world: Internal.ServerLevel_): void;
        isUnchangedSince(lastCheckedTime: number): boolean;
        listenToEntityMovementOnce(listener: Internal.SectionedEntityMovementListener_): void;
        emitEntityMovement(classMask: number, section: Internal.EntityMovementTrackerSection_): void;
        onSectionLeftRange(section: Internal.EntityMovementTrackerSection_): void;
        onSectionEnteredRange(section: Internal.EntityMovementTrackerSection_): void;
    }
    type SectionedEntityMovementTracker_<E extends Internal.EntityAccess, S> = SectionedEntityMovementTracker<E, S>;
    interface BeltProcessingBehaviour$ProcessingCallback {
        abstract apply(arg0: Internal.TransportedItemStack_, arg1: Internal.TransportedItemStackHandlerBehaviour_): Internal.BeltProcessingBehaviour$ProcessingResult;
        (arg0: Internal.TransportedItemStack, arg1: Internal.TransportedItemStackHandlerBehaviour): Internal.BeltProcessingBehaviour$ProcessingResult_;
    }
    type BeltProcessingBehaviour$ProcessingCallback_ = BeltProcessingBehaviour$ProcessingCallback;
    class DoorBlockBOP extends Internal.DoorBlock {
        constructor($$1: Internal.BlockSetType_, $$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type DoorBlockBOP_ = DoorBlockBOP;
    class BlockPos$MutableBlockPos extends BlockPos {
        constructor()
        constructor($$0: number, $$1: number, $$2: number)
        constructor($$0: number, $$1: number, $$2: number)
        method_20787(arg0: number): Vec3i;
        set($$0: number, $$1: number, $$2: number): this;
        method_20788(arg0: number): Vec3i;
        method_10099(arg0: number): Vec3i;
        setWithOffset($$0: Vec3i_, $$1: number, $$2: number, $$3: number): this;
        move($$0: Internal.Direction_): this;
        move($$0: Internal.Direction_, $$1: number): this;
        set($$0: Vec3i_): this;
        move($$0: Vec3i_): this;
        set($$0: number): this;
        set($$0: number, $$1: number, $$2: number): this;
        set($$0: Internal.AxisCycle_, $$1: number, $$2: number, $$3: number): this;
        clamp($$0: Internal.Direction$Axis_, $$1: number, $$2: number): this;
        setWithOffset($$0: Vec3i_, $$1: Vec3i_): this;
        setX($$0: number): this;
        setY($$0: number): this;
        move($$0: number, $$1: number, $$2: number): this;
        setWithOffset($$0: Vec3i_, $$1: Internal.Direction_): this;
        setZ($$0: number): this;
        set x($$0: number)
        set y($$0: number)
        set z($$0: number)
    }
    type BlockPos$MutableBlockPos_ = BlockPos$MutableBlockPos;
    interface MobAccessor {
        abstract getGoalSelector(): Internal.GoalSelector;
        get goalSelector(): Internal.GoalSelector
        (): Internal.GoalSelector_;
    }
    type MobAccessor_ = MobAccessor;
    class BasicMobEffect$Builder extends Internal.MobEffectBuilder {
        constructor(i: ResourceLocation_)
        createObject(): Internal.MobEffect;
    }
    type BasicMobEffect$Builder_ = BasicMobEffect$Builder;
    class DensityFunctions$Marker extends Internal.Record implements Internal.DensityFunctions$MarkerOrMarked {
        constructor($$0: Internal.DensityFunctions$Marker$Type_, $$1: Internal.DensityFunction_)
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        maxValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute($$0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        square(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        wrapped(): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        type(): Internal.DensityFunctions$Marker$Type;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        minValue(): number;
    }
    type DensityFunctions$Marker_ = DensityFunctions$Marker;
    interface UnitToken {
        unstack(resultStack: Internal.Stack_<Internal.UnitToken>): void;
        nextUnaryOperator(): boolean;
        interpret(stream: Internal.UnitTokenStream_): Internal.Unit;
    }
    type UnitToken_ = UnitToken;
    class LapisPipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.EnumProperty<Internal.FacingOrNone>;
    }
    type LapisPipeBlock_ = LapisPipeBlock;
    interface ICraftingLink {
        abstract getCraftingID(): Internal.UUID;
        abstract isStandalone(): boolean;
        abstract isCanceled(): boolean;
        abstract cancel(): void;
        abstract writeToNBT(arg0: Internal.CompoundTag_): void;
        abstract isDone(): boolean;
        get craftingID(): Internal.UUID
        get standalone(): boolean
        get canceled(): boolean
        get done(): boolean
    }
    type ICraftingLink_ = ICraftingLink;
    class QuartzCuttingKnifeItem extends Internal.AEBaseItem implements Internal.IMenuItem {
        constructor(props: Internal.Item$Properties_, type: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        getMenuHost(player: Internal.Player_, inventorySlot: number, stack: Internal.ItemStack_, pos: BlockPos_): Internal.ItemMenuHost;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type QuartzCuttingKnifeItem_ = QuartzCuttingKnifeItem;
    class ThrownTrident extends Internal.AbstractArrow {
        constructor($$0: Internal.Level_, $$1: Internal.LivingEntity_, $$2: Internal.ItemStack_)
        constructor($$0: Internal.EntityType_<Internal.ThrownTrident>, $$1: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        method_7446(): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isFoil(): boolean;
        getMotionX(): number;
        isChanneling(): boolean;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get foil(): boolean
        get motionX(): number
        get channeling(): boolean
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        dealtDamage: boolean;
        clientSideReturnTridentTickCount: number;
        static readonly ID_FOIL: Internal.EntityDataAccessor<boolean>;
        tridentItem: Internal.ItemStack;
        static readonly ID_LOYALTY: Internal.EntityDataAccessor<number>;
    }
    type ThrownTrident_ = ThrownTrident;
    class FireAspectEnchantment extends Internal.Enchantment {
    }
    type FireAspectEnchantment_ = FireAspectEnchantment;
    class BlockElementRotation extends Internal.Record {
        constructor($$0: Vec3f_, $$1: Internal.Direction$Axis_, $$2: number, $$3: boolean)
        axis(): Internal.Direction$Axis;
        origin(): Vec3f;
        angle(): number;
        rescale(): boolean;
    }
    type BlockElementRotation_ = BlockElementRotation;
    class EjectorBlockEntity$State extends Internal.Enum<Internal.EjectorBlockEntity$State> {
        static valueOf(name: string): Internal.EjectorBlockEntity$State;
        static values(): Internal.EjectorBlockEntity$State[];
        static readonly RETRACTING: Internal.EjectorBlockEntity$State;
        static readonly LAUNCHING: Internal.EjectorBlockEntity$State;
        static readonly CHARGED: Internal.EjectorBlockEntity$State;
    }
    type EjectorBlockEntity$State_ = EjectorBlockEntity$State | "charged" | "retracting" | "launching";
    class NativeImage$Format extends Internal.Enum<Internal.NativeImage$Format> {
        glFormat(): number;
        hasLuminanceOrBlue(): boolean;
        blueOffset(): number;
        setUnpackPixelStoreState(): void;
        redOffset(): number;
        hasAlpha(): boolean;
        setPackPixelStoreState(): void;
        hasLuminance(): boolean;
        hasLuminanceOrGreen(): boolean;
        luminanceOrBlueOffset(): number;
        luminanceOrGreenOffset(): number;
        hasLuminanceOrRed(): boolean;
        hasRed(): boolean;
        components(): number;
        static valueOf($$0: string): Internal.NativeImage$Format;
        hasGreen(): boolean;
        hasBlue(): boolean;
        luminanceOrRedOffset(): number;
        alphaOffset(): number;
        luminanceOrAlphaOffset(): number;
        hasLuminanceOrAlpha(): boolean;
        luminanceOffset(): number;
        static values(): Internal.NativeImage$Format[];
        supportedByStb(): boolean;
        greenOffset(): number;
        static readonly LUMINANCE: Internal.NativeImage$Format;
        static readonly RGB: Internal.NativeImage$Format;
        static readonly RGBA: Internal.NativeImage$Format;
        static readonly LUMINANCE_ALPHA: Internal.NativeImage$Format;
    }
    type NativeImage$Format_ = NativeImage$Format | "rgb" | "rgba" | "luminance" | "luminance_alpha";
    class AerialPearlItem extends owmii.powah.lib.item.ItemBase {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AerialPearlItem_ = AerialPearlItem;
    class InscriberRecipeSerializer implements Internal.RecipeSerializer<Internal.InscriberRecipe> {
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.InscriberRecipe;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: Internal.InscriberRecipe_): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        fromNetwork(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.InscriberRecipe;
        static readonly INSTANCE: Internal.InscriberRecipeSerializer;
    }
    type InscriberRecipeSerializer_ = InscriberRecipeSerializer;
    abstract class MoldingRecipe implements Internal.ICommonRecipe<Internal.IMoldingContainer> {
        constructor(id: ResourceLocation_, material: Internal.Ingredient_, pattern: Internal.Ingredient_, patternConsumed: boolean, recipeOutput: any_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getRemainingItems($$0: Internal.IMoldingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getSchema(): Internal.RecipeSchema;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        isPatternConsumed(): boolean;
        matches(inv: Internal.IMoldingContainer_, worldIn: Internal.Level_): boolean;
        assemble(inv: Internal.IMoldingContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getPattern(): Internal.Ingredient;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMaterial(): Internal.Ingredient;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get patternConsumed(): boolean
        get pattern(): Internal.Ingredient
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get material(): Internal.Ingredient
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type MoldingRecipe_ = MoldingRecipe;
    class OxygenEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
    }
    type OxygenEnchantment_ = OxygenEnchantment;
    class ChunkStatus {
        getParent(): this;
        hasLoadDependencies(): boolean;
        generate($$0: Internal.Executor_, $$1: Internal.ServerLevel_, $$2: Internal.ChunkGenerator_, $$3: Internal.StructureTemplateManager_, $$4: Internal.ThreadedLevelLightEngine_, $$5: Internal.Function_<Internal.ChunkAccess, Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>>, $$6: Internal.List_<Internal.ChunkAccess>): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        heightmapsAfter(): Internal.EnumSet<Internal.Heightmap$Types>;
        getRange(): number;
        getIndex(): number;
        static byName($$0: string): Internal.ChunkStatus;
        getChunkType(): Internal.ChunkStatus$ChunkType;
        static getStatusList(): Internal.List<Internal.ChunkStatus>;
        load($$0: Internal.ServerLevel_, $$1: Internal.StructureTemplateManager_, $$2: Internal.ThreadedLevelLightEngine_, $$3: Internal.Function_<Internal.ChunkAccess, Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>>, $$4: Internal.ChunkAccess_): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        static maxDistance(): number;
        isOrAfter($$0: Internal.ChunkStatus_): boolean;
        static getDistance($$0: Internal.ChunkStatus_): number;
        static getStatusAroundFullChunk($$0: number): Internal.ChunkStatus;
        get parent(): Internal.ChunkStatus
        get range(): number
        get index(): number
        get chunkType(): Internal.ChunkStatus$ChunkType
        get statusList(): Internal.List<Internal.ChunkStatus>
        static readonly LIGHT: Internal.ChunkStatus;
        static readonly EMPTY: Internal.ChunkStatus;
        static readonly CARVERS: Internal.ChunkStatus;
        static FULL: Internal.ChunkStatus;
        static readonly POST_FEATURES: Internal.EnumSet<Internal.Heightmap$Types>;
        static readonly FEATURES: Internal.ChunkStatus;
        static readonly SPAWN: Internal.ChunkStatus;
        static readonly SURFACE: Internal.ChunkStatus;
        static readonly STRUCTURE_REFERENCES: Internal.ChunkStatus;
        static readonly STRUCTURE_STARTS: Internal.ChunkStatus;
        static readonly BIOMES: Internal.ChunkStatus;
        static readonly INITIALIZE_LIGHT: Internal.ChunkStatus;
        static readonly MAX_STRUCTURE_DISTANCE: 8;
        static readonly NOISE: Internal.ChunkStatus;
    }
    type ChunkStatus_ = Special.ChunkStatus | ChunkStatus;
    class ValidationContext {
        constructor($$0: Internal.LootContextParamSet_, $$1: Internal.LootDataResolver_)
        constructor($$0: Internal.Multimap_<string, string>, $$1: Internal.Supplier_<string>, $$2: Internal.LootContextParamSet_, $$3: Internal.LootDataResolver_, $$4: Internal.Set_<Internal.LootDataId<any>>)
        forChild($$0: string): this;
        validateUser($$0: Internal.LootContextUser_): void;
        resolver(): Internal.LootDataResolver;
        getProblems(): Internal.Multimap<string, string>;
        hasVisitedElement($$0: Internal.LootDataId_<any>): boolean;
        enterElement($$0: string, $$1: Internal.LootDataId_<any>): this;
        setParams($$0: Internal.LootContextParamSet_): this;
        reportProblem($$0: string): void;
        get problems(): Internal.Multimap<string, string>
        set params($$0: Internal.LootContextParamSet_)
    }
    type ValidationContext_ = ValidationContext;
    class EnderConfig implements Internal.IEnergyConfig<owmii.powah.block.Tier> {
        constructor(transfer_rates: Internal.TieredEnergyValues_, channels: Internal.TieredChannelValues_)
        getTransfer(arg0: Internal.Enum_<any>): number;
        getTransfer(variant: owmii.powah.block.Tier_): number;
        getCapacity(arg0: Internal.Enum_<any>): number;
        getCapacity(variant: owmii.powah.block.Tier_): number;
        channels: Internal.TieredChannelValues;
        transfer_rates: Internal.TieredEnergyValues;
    }
    type EnderConfig_ = EnderConfig;
    abstract class SocketAddress implements Internal.Serializable {
        constructor()
    }
    type SocketAddress_ = SocketAddress;
    class CocoaDecorator extends Internal.TreeDecorator {
        constructor($$0: number)
        static readonly CODEC: Internal.Codec<Internal.CocoaDecorator>;
    }
    type CocoaDecorator_ = CocoaDecorator;
    class ComparatorMode extends Internal.Enum<Internal.ComparatorMode> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.ComparatorMode;
        static values(): Internal.ComparatorMode[];
        get serializedName(): string
        static readonly COMPARE: Internal.ComparatorMode;
        static readonly SUBTRACT: Internal.ComparatorMode;
    }
    type ComparatorMode_ = "compare" | ComparatorMode | "subtract";
    class DirectionalShaftHalvesBlockEntity extends Internal.KineticBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getSourceFacing(): Internal.Direction;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get sourceFacing(): Internal.Direction
        get renderBoundingBox(): Internal.AABB
    }
    type DirectionalShaftHalvesBlockEntity_ = DirectionalShaftHalvesBlockEntity;
    class NarrowGaugeBogeyBlock extends Internal.CRBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_, style: Internal.NarrowGaugeBogeyBlock$NarrowGaugeStandardStyle_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        static create(style: Internal.NarrowGaugeBogeyBlock$NarrowGaugeStandardStyle_): com.tterrag.registrate.util.nullness.NonNullFunction<Internal.BlockBehaviour$Properties, Internal.NarrowGaugeBogeyBlock>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        readonly style: Internal.NarrowGaugeBogeyBlock$NarrowGaugeStandardStyle;
    }
    type NarrowGaugeBogeyBlock_ = NarrowGaugeBogeyBlock;
    class VanillaPackResources implements Internal.PackResources {
        getResource($$0: Internal.PackType_, $$1: ResourceLocation_): Internal.IoSupplier<Internal.InputStream>;
        getRootResource(...$$0: string[]): Internal.IoSupplier<Internal.InputStream>;
        packId(): string;
        listResources($$0: Internal.PackType_, $$1: string, $$2: string, $$3: Internal.PackResources$ResourceOutput_): void;
        close(): void;
        getNamespaces($$0: Internal.PackType_): Internal.Set<string>;
        listRawPaths($$0: Internal.PackType_, $$1: ResourceLocation_, $$2: Internal.Consumer_<Internal.Path>): void;
        isBuiltin(): boolean;
        getMetadataSection<T>($$0: Internal.MetadataSectionSerializer_<T>): T;
        asProvider(): Internal.ResourceProvider;
        get builtin(): boolean
    }
    type VanillaPackResources_ = VanillaPackResources;
    class AutomationDirection extends Internal.Enum<Internal.AutomationDirection> implements Internal.StringRepresentable {
        static valueOf(name: string): Internal.AutomationDirection;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static fromName(name: string): Internal.AutomationDirection;
        static values(): Internal.AutomationDirection[];
        next(): this;
        get serializedName(): string
        static readonly INPUT: Internal.AutomationDirection;
        static readonly OFF: Internal.AutomationDirection;
        static readonly OUTPUT: Internal.AutomationDirection;
        static readonly KEEP: Internal.AutomationDirection;
    }
    type AutomationDirection_ = "keep" | "output" | "off" | "input" | AutomationDirection;
    class EndCrystalItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EndCrystalItem_ = EndCrystalItem;
    class FloatArgumentType implements Internal.ArgumentType<number> {
        getMaximum(): number;
        getExamples(): Internal.Collection<string>;
        static floatArg(arg0: number, arg1: number): Internal.FloatArgumentType;
        static floatArg(arg0: number): Internal.FloatArgumentType;
        static floatArg(): Internal.FloatArgumentType;
        static getFloat(arg0: Internal.CommandContext_<any>, arg1: string): number;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        getMinimum(): number;
        parse(arg0: Internal.StringReader_): any;
        get maximum(): number
        get examples(): Internal.Collection<string>
        get minimum(): number
    }
    type FloatArgumentType_ = FloatArgumentType;
    abstract class ScheduleInstruction extends Internal.ScheduleDataEntry {
        constructor()
        write(): Internal.CompoundTag;
        getItem(slot: number): Internal.ItemStack;
        slotsTargeted(): number;
        getSecondLineTooltip(slot: number): Internal.List<net.minecraft.network.chat.Component>;
        abstract start(arg0: Internal.ScheduleRuntime_, arg1: Internal.Level_): Internal.DiscoveredPath;
        setItem(slot: number, stack: Internal.ItemStack_): void;
        static fromTag(tag: Internal.CompoundTag_): Internal.ScheduleInstruction;
        getSecondLineIcon(): Internal.ItemStack;
        getTitleAs(type: string): Internal.List<net.minecraft.network.chat.Component>;
        abstract supportsConditions(): boolean;
        renderSpecialIcon(graphics: Internal.GuiGraphics_, x: number, y: number): boolean;
        initConfigurationWidgets(builder: Internal.ModularGuiLineBuilder_): void;
        get secondLineIcon(): Internal.ItemStack
    }
    type ScheduleInstruction_ = ScheduleInstruction;
    interface FluidRenderHandler extends Internal.FluidRenderHandlerMixin, Internal.FluidRenderHandlerExtension {
        renderFluid(pos: BlockPos_, world: Internal.BlockAndTintGetter_, vertexConsumer: Internal.VertexConsumer_, blockState: Internal.BlockState_, fluidState: Internal.FluidState_): void;
        getFluidModel(): Internal.FluidBakedModel;
        abstract getFluidSprites(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: Internal.FluidState_): Internal.TextureAtlasSprite[];
        getFluidColor(view: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.FluidState_): number;
        reloadTextures(textureAtlas: Internal.TextureAtlas_): void;
        get fluidModel(): Internal.FluidBakedModel
        (arg0: Internal.BlockAndTintGetter, arg1: BlockPos, arg2: Internal.FluidState): Internal.TextureAtlasSprite_[];
    }
    type FluidRenderHandler_ = FluidRenderHandler;
    class ImposterProtoChunk extends Internal.ProtoChunk implements Internal.AttachmentTargetImpl, Internal.ComponentProvider, Internal.ExtendedChunk {
        constructor($$0: Internal.LevelChunk_, $$1: boolean)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getMinSection(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getMaxSection(): number;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getAllReferences(): Internal.Map<Internal.Structure, Internal.LongSet>;
        getSectionYFromSectionIndex($$0: number): number;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        getWrapped(): Internal.LevelChunk;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getSectionsCount(): number;
        hasBiomes(): boolean;
        getSectionIndexFromSectionY($$0: number): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get allReferences(): Internal.Map<Internal.Structure, Internal.LongSet>
        get wrapped(): Internal.LevelChunk
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get sectionsCount(): number
    }
    type ImposterProtoChunk_ = ImposterProtoChunk;
    class SingletonImmutableList <E> extends Internal.ImmutableList<E> {
        addLast(arg0: E): void;
        get(arg0: number): E;
        getLast(): E;
        iterator(): Internal.Iterator<any>;
        addFirst(arg0: E): void;
        abstract toArray<T>(arg0: T[]): T[];
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        getFirst(): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        subList(arg0: number, arg1: number): Internal.List<any>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        reversed(): Internal.SequencedCollection<any>;
        spliterator(): Internal.Spliterator<E>;
        removeLast(): E;
        listIterator(): Internal.ListIterator<any>;
        get last(): E
        get first(): E
    }
    type SingletonImmutableList_<E> = SingletonImmutableList<E>;
    class AbsoptionMobEffect extends Internal.MobEffect {
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
        getRenderer(): Internal.MobEffectRenderer;
        get curativeItems(): Internal.List<Internal.ItemStack>
        get renderer(): Internal.MobEffectRenderer
    }
    type AbsoptionMobEffect_ = AbsoptionMobEffect;
    interface FabricBlockState {
        getAppearance(renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
    }
    type FabricBlockState_ = FabricBlockState;
    class StateDefinition <O, S extends Internal.StateHolder<O, S>> {
        static appendPropertyCodec<S extends Internal.StateHolder<any, S>, T extends Internal.Comparable<T>>($$0: Internal.MapCodec_<S>, $$1: Internal.Supplier_<S>, $$2: string, $$3: Internal.Property_<T>): Internal.MapCodec<S>;
        getProperties(): Internal.Collection<Internal.Property<any>>;
        getPossibleStates(): Internal.ImmutableList<S>;
        getOwner(): O;
        any(): S;
        getProperty($$0: string): Internal.Property<any>;
        get properties(): Internal.Collection<Internal.Property<any>>
        get possibleStates(): Internal.ImmutableList<S>
        get owner(): O
    }
    type StateDefinition_<O, S extends Internal.StateHolder<O, S>> = StateDefinition<O, S>;
    class ClientboundStopSoundPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: ResourceLocation_, $$1: Internal.SoundSource_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getSource(): Internal.SoundSource;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getName(): ResourceLocation;
        isSkippable(): boolean;
        get source(): Internal.SoundSource
        get name(): ResourceLocation
        get skippable(): boolean
    }
    type ClientboundStopSoundPacket_ = ClientboundStopSoundPacket;
    class ChunkRenderDispatcher$CompiledChunk {
        constructor()
        facesCanSeeEachother($$0: Internal.Direction_, $$1: Internal.Direction_): boolean;
        getRenderableBlockEntities(): Internal.List<Internal.BlockEntity>;
        hasNoRenderableLayers(): boolean;
        isEmpty($$0: Internal.RenderType_): boolean;
        get renderableBlockEntities(): Internal.List<Internal.BlockEntity>
        static readonly UNCOMPILED: Internal.ChunkRenderDispatcher$CompiledChunk;
    }
    type ChunkRenderDispatcher$CompiledChunk_ = ChunkRenderDispatcher$CompiledChunk;
    class MultiblockPart$MultiblockMainPart$MultiblockPartType extends Internal.Enum<Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType> {
        static valueOf(name: string): Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        getBlockState(facing: Internal.Direction_): Internal.BlockState;
        static values(): Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType[];
        static readonly ITEM_OUT: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        static readonly FLUID_IN: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        static readonly FLUID_OUT: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        static readonly MAIN: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        static readonly KINETIC: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        static readonly ITEM_IN: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        static readonly BLANK: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
    }
    type MultiblockPart$MultiblockMainPart$MultiblockPartType_ = "item_out" | "main" | "kinetic" | "fluid_out" | "item_in" | MultiblockPart$MultiblockMainPart$MultiblockPartType | "blank" | "fluid_in";
    class ModifierRemovalRecipe extends Internal.AbstractWorktableRecipe {
        constructor(id: ResourceLocation_, toolRequirement: Internal.SizedIngredient_, inputs: Internal.List_<Internal.SizedIngredient>, leftovers: Internal.List_<Internal.ItemStack>, modifierPredicate: any_<Internal.ModifierId>)
        constructor(id: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>, leftovers: Internal.List_<Internal.ItemStack>, modifierPredicate: any_<Internal.ModifierId>)
        constructor(id: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>, leftovers: Internal.List_<Internal.ItemStack>)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        updateInputs(result: Internal.IToolStackView_, inv: Internal.ITinkerableContainer$Mutable_, selected: Internal.ModifierEntry_, isServer: boolean): void;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        toolResultSize(inv: Internal.ITinkerableContainer_, selected: Internal.ModifierEntry_): number;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        /**
         * @deprecated
        */
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        isModifierOutput(): boolean;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getRemainingItems($$0: Internal.ITinkerableContainer_): Internal.NonNullList<Internal.ItemStack>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        /**
         * @deprecated
        */
        assemble(inv: Internal.ITinkerableContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get modifierOutput(): boolean
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type ModifierRemovalRecipe_ = ModifierRemovalRecipe;
    interface FluidCachingEntity {
    }
    type FluidCachingEntity_ = FluidCachingEntity;
    class OperatorVec3Delegating extends Internal.OperatorBasic {
        constructor(core: Internal.BiFunction_<Vec3d, Vec3d, Internal.Iota>, fallback: Internal.HexPattern_)
        static triplicate(in_: number): Vec3d;
    }
    type OperatorVec3Delegating_ = OperatorVec3Delegating;
    class ClockworkBearingBlockEntity extends Internal.KineticBlockEntity implements Internal.IDisplayAssemblyExceptions, Internal.IBearingBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getMinuteArmSpeed(): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getAngularSpeed(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlockPosition(): BlockPos;
        assemble(): void;
        addExceptionToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>): boolean;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        isValid(): boolean;
        getHourArmSpeed(): number;
        invalidateCaps(): void;
        isRunning(): boolean;
        getMovementModeSlot(): Internal.ValueBoxTransform;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isWoodenTop(): boolean;
        getInterpolatedAngle(partialTicks: number): number;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isAttachedTo(contraption: Internal.AbstractContraptionEntity_): boolean;
        setAngle(forcedAngle: number): void;
        getInfiniteBoundingBox(): Internal.AABB;
        attach(contraption: Internal.ControlledContraptionEntity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        disassemble(): void;
        onStall(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getLastAssemblyException(): Internal.AssemblyException;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get minuteArmSpeed(): number
        get angularSpeed(): number
        get blockPosition(): BlockPos
        get valid(): boolean
        get hourArmSpeed(): number
        get running(): boolean
        get movementModeSlot(): Internal.ValueBoxTransform
        get woodenTop(): boolean
        set angle(forcedAngle: number)
        get infiniteBoundingBox(): Internal.AABB
        get lastAssemblyException(): Internal.AssemblyException
        get renderBoundingBox(): Internal.AABB
    }
    type ClockworkBearingBlockEntity_ = ClockworkBearingBlockEntity;
    class PowderSnowCauldronBlock extends Internal.LayeredCauldronBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.Predicate_<Internal.Biome$Precipitation>, $$2: Internal.Map_<Internal.Item, Internal.CauldronInteraction>)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type PowderSnowCauldronBlock_ = PowderSnowCauldronBlock;
    class ClampedNormalInt extends Internal.IntProvider {
        static sample($$0: Internal.RandomSource_, $$1: number, $$2: number, $$3: number, $$4: number): number;
        static of($$0: number, $$1: number, $$2: number, $$3: number): Internal.ClampedNormalInt;
        static readonly CODEC: Internal.Codec<Internal.ClampedNormalInt>;
    }
    type ClampedNormalInt_ = ClampedNormalInt;
    class InetSocketAddress extends Internal.SocketAddress {
        constructor(arg0: string, arg1: number)
        constructor(arg0: number)
        constructor(arg0: Internal.InetAddress_, arg1: number)
        getHostName(): string;
        static createUnresolved(arg0: string, arg1: number): Internal.InetSocketAddress;
        isUnresolved(): boolean;
        getPort(): number;
        getAddress(): Internal.InetAddress;
        getHostString(): string;
        get hostName(): string
        get unresolved(): boolean
        get port(): number
        get address(): Internal.InetAddress
        get hostString(): string
    }
    type InetSocketAddress_ = InetSocketAddress;
    interface DensityFunctions$BeardifierOrMarker extends Internal.DensityFunction$SimpleFunction {
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        abstract maxValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        abstract compute(arg0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        square(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        abstract minValue(): number;
        readonly CODEC: Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
    }
    type DensityFunctions$BeardifierOrMarker_ = DensityFunctions$BeardifierOrMarker;
    abstract class BooleanDirectionsPipeBlock extends jagm.classicpipes.block.PipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
        static readonly NORTH: Internal.BooleanProperty;
        static readonly PROPERTY_BY_DIRECTION: {[key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty};
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly UP: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly DOWN: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type BooleanDirectionsPipeBlock_ = BooleanDirectionsPipeBlock;
    class IronGolem extends Internal.AbstractGolem implements Internal.NeutralMob {
        constructor($$0: Internal.EntityType_<Internal.IronGolem>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        readPersistentAngerSaveData($$0: Internal.Level_, $$1: Internal.CompoundTag_): void;
        stopBeingAngry(): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        getAttackAnimationTick(): number;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getOfferFlowerTick(): number;
        attack(hp: number): void;
        setPlayerCreated($$0: boolean): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        forgetCurrentTargetAndRefreshUniversalAnger(): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        addPersistentAngerSaveData($$0: Internal.CompoundTag_): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        getPersistentAngerTarget(): Internal.UUID;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        isAngryAtAllPlayers($$0: Internal.Level_): boolean;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        playerDied($$0: Internal.Player_): void;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isAngry(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        offerFlower($$0: boolean): void;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        startPersistentAngerTimer(): void;
        isMonster(): boolean;
        setRemainingPersistentAngerTime($$0: number): void;
        getType(): string;
        isPlayerCreated(): boolean;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getCrackiness(): Internal.IronGolem$Crackiness;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        setPersistentAngerTarget($$0: Internal.UUID_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        isAngryAt($$0: Internal.LivingEntity_): boolean;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getRemainingPersistentAngerTime(): number;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        updatePersistentAnger($$0: Internal.ServerLevel_, $$1: boolean): void;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get attackAnimationTick(): number
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get offerFlowerTick(): number
        set playerCreated($$0: boolean)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get persistentAngerTarget(): Internal.UUID
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get angry(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        set remainingPersistentAngerTime($$0: number)
        get type(): string
        get playerCreated(): boolean
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get crackiness(): Internal.IronGolem$Crackiness
        set persistentAngerTarget($$0: Internal.UUID_)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get remainingPersistentAngerTime(): number
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type IronGolem_ = IronGolem;
    interface PackResources$ResourceOutput extends Internal.BiConsumer<ResourceLocation, Internal.IoSupplier<Internal.InputStream>> {
        andThen(arg0: Internal.BiConsumer_<ResourceLocation, Internal.IoSupplier<Internal.InputStream>>): Internal.BiConsumer<ResourceLocation, Internal.IoSupplier<Internal.InputStream>>;
        abstract accept(arg0: ResourceLocation_, arg1: Internal.IoSupplier_<Internal.InputStream>): void;
        (arg0: ResourceLocation, arg1: Internal.IoSupplier<Internal.InputStream>): void;
    }
    type PackResources$ResourceOutput_ = PackResources$ResourceOutput;
    interface ContinueUsingItem {
        canContinueUsing(oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
    }
    type ContinueUsingItem_ = ContinueUsingItem;
    class RegistryEntry <T> implements Internal.NonNullSupplier<T> {
        constructor(owner: Internal.AbstractRegistrate_<any>, delegate: Internal.RegistryObject_<T>)
        stream(): Internal.Stream<T>;
        getSibling<R, E extends R>(registryType: Internal.ResourceKey_<Internal.Registry<R>>): Internal.RegistryEntry<E>;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        ifPresent(consumer: Internal.Consumer_<T>): void;
        orElseGet(other: Internal.Supplier_<T>): T;
        flatMap<U>(mapper: Internal.Function_<T, Internal.Optional<U>>): Internal.Optional<U>;
        is<R>(entry: R): boolean;
        updateReference(registry: Internal.Registry_<T>): void;
        static empty<T>(): Internal.RegistryEntry<T>;
        lazyMap<U>(mapper: Internal.Function_<T, U>): Internal.Supplier<U>;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        filter(predicate: Internal.Predicate_<T>): this;
        orElse(other: T): T;
        isPresent(): boolean;
        getId(): ResourceLocation;
        map<U>(mapper: Internal.Function_<T, U>): Internal.Optional<U>;
        orElseThrow<X extends Internal.Throwable>(exceptionSupplier: Internal.Supplier_<X>): T;
        lazy(): Internal.NonNullSupplier<T>;
        getSibling<R, E extends R>(registry: Internal.Registry_<R>): Internal.RegistryEntry<E>;
        get(): T;
        getUnchecked(): T;
        get present(): boolean
        get id(): ResourceLocation
        get unchecked(): T
    }
    type RegistryEntry_<T> = RegistryEntry<T>;
    class VarHandle$AccessMode extends Internal.Enum<Internal.VarHandle$AccessMode> {
        static valueFromMethodName(arg0: string): Internal.VarHandle$AccessMode;
        static values(): Internal.VarHandle$AccessMode[];
        static valueOf(arg0: string): Internal.VarHandle$AccessMode;
        methodName(): string;
        static readonly GET_AND_BITWISE_AND_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_OR: Internal.VarHandle$AccessMode;
        static readonly COMPARE_AND_SET: Internal.VarHandle$AccessMode;
        static readonly GET_AND_SET_RELEASE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_OR_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly GET: Internal.VarHandle$AccessMode;
        static readonly GET_AND_ADD: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_AND_RELEASE: Internal.VarHandle$AccessMode;
        static readonly GET_OPAQUE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_AND: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_XOR: Internal.VarHandle$AccessMode;
        static readonly SET_OPAQUE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_SET: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_XOR_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly SET_VOLATILE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_OR_RELEASE: Internal.VarHandle$AccessMode;
        static readonly COMPARE_AND_EXCHANGE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_SET_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly GET_VOLATILE: Internal.VarHandle$AccessMode;
        static readonly GET_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_ADD_RELEASE: Internal.VarHandle$AccessMode;
        static readonly SET: Internal.VarHandle$AccessMode;
        static readonly GET_AND_ADD_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly WEAK_COMPARE_AND_SET: Internal.VarHandle$AccessMode;
        static readonly COMPARE_AND_EXCHANGE_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly GET_AND_BITWISE_XOR_RELEASE: Internal.VarHandle$AccessMode;
        static readonly SET_RELEASE: Internal.VarHandle$AccessMode;
        static readonly COMPARE_AND_EXCHANGE_RELEASE: Internal.VarHandle$AccessMode;
        static readonly WEAK_COMPARE_AND_SET_ACQUIRE: Internal.VarHandle$AccessMode;
        static readonly WEAK_COMPARE_AND_SET_RELEASE: Internal.VarHandle$AccessMode;
        static readonly WEAK_COMPARE_AND_SET_PLAIN: Internal.VarHandle$AccessMode;
    }
    type VarHandle$AccessMode_ = "get_and_set_acquire" | "get_and_bitwise_and" | "weak_compare_and_set_acquire" | "get_and_set" | "get_and_bitwise_xor_acquire" | "compare_and_set" | "weak_compare_and_set_release" | "get_and_bitwise_xor_release" | "get_and_add_acquire" | "get_and_add_release" | "get_and_bitwise_xor" | "get_and_bitwise_or" | VarHandle$AccessMode | "get" | "set_release" | "weak_compare_and_set_plain" | "get_and_add" | "get_and_bitwise_or_acquire" | "get_acquire" | "get_and_bitwise_and_acquire" | "compare_and_exchange_acquire" | "get_opaque" | "compare_and_exchange" | "get_and_bitwise_or_release" | "set" | "get_volatile" | "set_volatile" | "weak_compare_and_set" | "get_and_set_release" | "compare_and_exchange_release" | "set_opaque" | "get_and_bitwise_and_release";
    class PlatformBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type PlatformBlock_ = PlatformBlock;
    class MyceliumBlock extends Internal.SpreadingSnowyDirtBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MyceliumBlock_ = MyceliumBlock;
    class CreativeFluidTankMountedStorage extends Internal.WrapperMountedFluidStorage<any> {
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static fromLegacy(nbt: Internal.CompoundTag_): Internal.CreativeFluidTankMountedStorage;
        static fromTank(tank: Internal.CreativeFluidTankBlockEntity_): Internal.CreativeFluidTankMountedStorage;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        static empty<T>(): Internal.Storage<T>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        static asClass<T>(): Internal.Storage<T>;
        static readonly CODEC: Internal.Codec<Internal.CreativeFluidTankMountedStorage>;
    }
    type CreativeFluidTankMountedStorage_ = CreativeFluidTankMountedStorage;
    class LootScoreProviderType extends Internal.SerializerType<any> {
        constructor($$0: Internal.Serializer_<any>)
    }
    type LootScoreProviderType_ = Special.LootScoreProviderType | LootScoreProviderType;
    abstract class AbstractChestedHorse extends Internal.AbstractHorse {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getJumpCooldown(): number;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        setChest($$0: boolean): void;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        handler$hci001$resourcechickens$interactMob(player: Internal.Player_, hand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasChest(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getInventoryColumns(): number;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        static createBaseChestedHorseAttributes(): Internal.AttributeSupplier$Builder;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get jumpCooldown(): number
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        set chest($$0: boolean)
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get inventoryColumns(): number
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly INV_CHEST_COUNT: 15;
    }
    type AbstractChestedHorse_ = AbstractChestedHorse;
    abstract class DataBuffer {
        getElem(arg0: number): number;
        getElemFloat(arg0: number, arg1: number): number;
        getOffsets(): number[];
        setElemDouble(arg0: number, arg1: number): void;
        getNumBanks(): number;
        setElemFloat(arg0: number, arg1: number): void;
        getElemDouble(arg0: number, arg1: number): number;
        setElem(arg0: number, arg1: number): void;
        abstract setElem(arg0: number, arg1: number, arg2: number): void;
        abstract getElem(arg0: number, arg1: number): number;
        getSize(): number;
        setElemDouble(arg0: number, arg1: number, arg2: number): void;
        getElemDouble(arg0: number): number;
        getOffset(): number;
        setElemFloat(arg0: number, arg1: number, arg2: number): void;
        static getDataTypeSize(arg0: number): number;
        getDataType(): number;
        getElemFloat(arg0: number): number;
        get offsets(): number[]
        get numBanks(): number
        get size(): number
        get offset(): number
        get dataType(): number
        static readonly TYPE_UNDEFINED: 32;
        static readonly TYPE_USHORT: 1;
        static readonly TYPE_FLOAT: 4;
        static readonly TYPE_INT: 3;
        static readonly TYPE_BYTE: 0;
        static readonly TYPE_SHORT: 2;
        static readonly TYPE_DOUBLE: 5;
    }
    type DataBuffer_ = DataBuffer;
    interface ResourceMetadata {
        abstract getSection<T>(arg0: Internal.MetadataSectionSerializer_<T>): Internal.Optional<T>;
        fromJsonStream($$0: Internal.InputStream_): this;
        (arg0: Internal.MetadataSectionSerializer<T>): Internal.Optional_<T>;
        readonly EMPTY: Internal.ResourceMetadata;
        readonly EMPTY_SUPPLIER: Internal.IoSupplier<Internal.ResourceMetadata>;
    }
    type ResourceMetadata_ = ResourceMetadata;
    interface Double2ShortFunction extends Internal.DoubleToIntFunction, it.unimi.dsi.fastutil.Function<number, number> {
        getOrDefault(arg0: number, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2ShortFunction<T>;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Double2FloatFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Double2CharFunction;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Double2IntFunction;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2ShortFunction;
        defaultReturnValue(): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Double2ByteFunction;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Double2DoubleFunction;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2ShortFunction;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2ShortFunction;
        put(arg0: number, arg1: number): number;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2ShortFunction;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        size(): number;
        apply(arg0: number): number;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2ShortFunction<T>;
        defaultReturnValue(arg0: number): void;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Double2LongFunction;
        clear(): void;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        abstract get(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2ShortFunction;
        applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type Double2ShortFunction_ = Double2ShortFunction;
    class AgriStat implements Internal.AgriRegistrable {
        constructor(id: string, min: Internal.IntSupplier_, max: Internal.IntSupplier_, hidden: Internal.BooleanSupplier_, color: number)
        getColor(): number;
        addTooltip(consumer: Internal.Consumer_<net.minecraft.network.chat.Component>, value: number): void;
        getMax(): number;
        isHidden(): boolean;
        getMin(): number;
        getId(): string;
        get color(): number
        get max(): number
        get hidden(): boolean
        get min(): number
        get id(): string
    }
    type AgriStat_ = AgriStat;
    class View <A, B> extends Internal.Record implements Internal.App2<any, A, B> {
        constructor(function_: Internal.PointFree_<Internal.Function<A, B>>)
        type(): com.mojang.datafixers.types.Type<A>;
        static nopView<A>(arg0: com.mojang.datafixers.types.Type_<A>): Internal.View<A, A>;
        funcType(): com.mojang.datafixers.types.Type<Internal.Function<A, B>>;
        flatMap<C>(arg0: Internal.Function_<com.mojang.datafixers.types.Type<B>, Internal.View<B, C>>): Internal.View<A, C>;
        static create<A, B>(arg0: string, arg1: com.mojang.datafixers.types.Type_<A>, arg2: com.mojang.datafixers.types.Type_<B>, arg3: Internal.Function_<Internal.DynamicOps<any>, Internal.Function<A, B>>): Internal.View<A, B>;
        compose<C>(arg0: Internal.View_<C, A>): Internal.View<C, B>;
        rewrite(arg0: Internal.PointFreeRule_): Internal.Optional<Internal.View<A, B>>;
        isNop(): boolean;
        newType(): com.mojang.datafixers.types.Type<B>;
        static create<A, B>(arg0: Internal.PointFree_<Internal.Function<A, B>>): Internal.View<A, B>;
        "function"(): Internal.PointFree<Internal.Function<A, B>>;
        rewriteOrNop(arg0: Internal.PointFreeRule_): this;
        get nop(): boolean
    }
    type View_<A, B> = View<A, B>;
    class WaterloggedVegetationPatchFeature extends Internal.VegetationPatchFeature {
        constructor($$0: Internal.Codec_<Internal.VegetationPatchConfiguration>)
    }
    type WaterloggedVegetationPatchFeature_ = WaterloggedVegetationPatchFeature;
    class AgriPlant {
        constructor(mods: Internal.List_<string>, seeds: Internal.List_<Internal.AgriSeed>, stages: Internal.List_<number>, harvestStage: number, growthChance: number, growthBonus: number, cloneable: boolean, fireproof: boolean, spreadChance: number, products: Internal.List_<any>, clipProducts: Internal.List_<any>, requirement: Internal.AgriRequirement_, modifierInfos: Internal.List_<any>, particleEffects: Internal.List_<any>)
        allowsClipping(growthStage: Internal.AgriGrowthStage_, clipper: Internal.ItemStack_, entity: Internal.LivingEntity_): boolean;
        onHarvest(crop: Internal.AgriCrop_, entity: Internal.LivingEntity_): void;
        getClipProducts(products: Internal.Consumer_<Internal.ItemStack>, clipper: Internal.ItemStack_, growthStage: Internal.AgriGrowthStage_, genome: Internal.AgriGenome_, random: Internal.RandomSource_): void;
        allowHarvest(growthStage: Internal.AgriGrowthStage_, entity: Internal.LivingEntity_): boolean;
        onPlanted(crop: Internal.AgriCrop_, entity: Internal.LivingEntity_): void;
        getRedstonePower(crop: Internal.AgriCrop_): number;
        getPlantHeight(stage: Internal.AgriGrowthStage_): number;
        onRemoved(crop: Internal.AgriCrop_): void;
        getGrowthStageAfterHarvest(): Internal.AgriGrowthStage;
        allowsCloning(growthStage: Internal.AgriGrowthStage_): boolean;
        isSeedItem(stack: Internal.ItemStack_): boolean;
        onGrowth(crop: Internal.AgriCrop_): void;
        getHarvestProducts(products: Internal.Consumer_<Internal.ItemStack>, growthStage: Internal.AgriGrowthStage_, genome: Internal.AgriGenome_, random: Internal.RandomSource_): void;
        onEntityCollision(crop: Internal.AgriCrop_, entity: Internal.Entity_): void;
        getBrightness(crop: Internal.AgriCrop_): number;
        getGrowthChance(growthStage: Internal.AgriGrowthStage_): number;
        onClipped(crop: Internal.AgriCrop_, clipper: Internal.ItemStack_, entity: Internal.LivingEntity_): void;
        onSpawned(crop: Internal.AgriCrop_): void;
        getAllPossibleProducts(products: Internal.Consumer_<Internal.ItemStack>): void;
        getGrowthRequirements(): Internal.AgriRequirement;
        onRightClickPost(crop: Internal.AgriCrop_, stack: Internal.ItemStack_, entity: Internal.Entity_): Internal.Optional<Internal.InteractionResult>;
        getSpreadChance(growthStage: Internal.AgriGrowthStage_): number;
        getAllPossibleClipProducts(products: Internal.Consumer_<Internal.ItemStack>): void;
        onRightClickPre(crop: Internal.AgriCrop_, stack: Internal.ItemStack_, entity: Internal.Entity_): Internal.Optional<Internal.InteractionResult>;
        onFertilized(crop: Internal.AgriCrop_, fertilizer: Internal.ItemStack_, random: Internal.RandomSource_): void;
        spawnParticles(crop: Internal.AgriCrop_, random: Internal.RandomSource_): void;
        onBroken(crop: Internal.AgriCrop_, entity: Internal.LivingEntity_): void;
        onRandomTick(crop: Internal.AgriCrop_, random: Internal.RandomSource_): void;
        getModifiers(): Internal.Stream<Internal.IAgriPlantModifier>;
        getSeed(stack: Internal.ItemStack_): Internal.AgriSeed;
        isFireproof(): boolean;
        getBonusGrowthChance(growthStage: Internal.AgriGrowthStage_): number;
        getInitialGrowthStage(): Internal.AgriGrowthStage;
        get growthStageAfterHarvest(): Internal.AgriGrowthStage
        get growthRequirements(): Internal.AgriRequirement
        get modifiers(): Internal.Stream<Internal.IAgriPlantModifier>
        get fireproof(): boolean
        get initialGrowthStage(): Internal.AgriGrowthStage
        static readonly CODEC: Internal.Codec<Internal.AgriPlant>;
        static readonly UNKNOWN: ResourceLocation;
        static readonly NO_PLANT: Internal.AgriPlant;
    }
    type AgriPlant_ = AgriPlant | Special.Plants;
    class RemoteLensItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RemoteLensItem_ = RemoteLensItem;
    class ItemPatternModifier extends Internal.AEBaseItem implements Internal.IMenuItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        getMenuHost(player: Internal.Player_, inventorySlot: number, stack: Internal.ItemStack_, pos: BlockPos_): Internal.ItemMenuHost;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemPatternModifier_ = ItemPatternModifier;
    class TaigaTreeConfiguration extends Internal.BOPTreeConfiguration {
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.TaigaTreeConfiguration>;
        readonly trunkWidth: number;
    }
    type TaigaTreeConfiguration_ = TaigaTreeConfiguration;
    class MaterialNBT$Builder {
        constructor()
        add(material: Internal.IMaterial_): this;
        build(): Internal.MaterialNBT;
        add(variant: Internal.MaterialVariant_): this;
        add(variantId: Internal.MaterialVariantId_): this;
    }
    type MaterialNBT$Builder_ = MaterialNBT$Builder;
    class BlockItemBuilder extends Internal.ItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): any;
        blockBuilder: Internal.BlockBuilder;
    }
    type BlockItemBuilder_ = BlockItemBuilder;
    interface LongIterator extends Internal.PrimitiveIterator$OfLong {
        forEachRemaining(arg0: any): void;
        remove(): void;
        /**
         * @deprecated
        */
        next(): any;
        skip(arg0: number): number;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        abstract nextLong(): number;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): void;
        abstract hasNext(): boolean;
        forEachRemaining(arg0: Internal.LongConsumer_): void;
    }
    type LongIterator_ = LongIterator;
    class GantryCarriageBlock extends Internal.DirectionalAxisKineticBlock implements Internal.IBE<Internal.GantryCarriageBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.GantryCarriageBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static getValidGantryShaftAxis(state: Internal.BlockState_): Internal.Direction$Axis;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.GantryCarriageBlockEntity>;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.GantryCarriageBlockEntity>): void;
        setRequiresTool(v: boolean): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.GantryCarriageBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        static getValidGantryPinionAxis(state: Internal.BlockState_, shaftAxis: Internal.Direction$Axis_): Internal.Direction$Axis;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static isValidGantryShaftAxis(pinionState: Internal.BlockState_, gantryState: Internal.BlockState_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.GantryCarriageBlockEntity;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntityClass(): typeof Internal.GantryCarriageBlockEntity;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.GantryCarriageBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockEntityClass(): typeof Internal.GantryCarriageBlockEntity
    }
    type GantryCarriageBlock_ = GantryCarriageBlock;
    interface ITabbedBlock {
        abstract openGui(arg0: Internal.Player_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        (arg0: Internal.Player, arg1: Internal.Level, arg2: BlockPos): boolean;
    }
    type ITabbedBlock_ = ITabbedBlock;
    class WrenchMode extends Internal.Enum<Internal.WrenchMode> {
        config(): boolean;
        static valueOf(name: string): Internal.WrenchMode;
        rotate(): boolean;
        static values(): Internal.WrenchMode[];
        link(): boolean;
        static readonly CONFIG: Internal.WrenchMode;
        static readonly LINK: Internal.WrenchMode;
        static readonly ROTATE: Internal.WrenchMode;
    }
    type WrenchMode_ = "config" | WrenchMode | "rotate" | "link";
    class WirelessTerminalItem$LinkableHandler implements Internal.IGridLinkableHandler {
        canLink(stack: Internal.ItemStack_): boolean;
        unlink(itemStack: Internal.ItemStack_): void;
        link(itemStack: Internal.ItemStack_, pos: Internal.GlobalPos_): void;
    }
    type WirelessTerminalItem$LinkableHandler_ = WirelessTerminalItem$LinkableHandler;
    class ItemStackIota$1 extends Internal.IotaType<Internal.ItemStackIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.ItemStackIota;
    }
    type ItemStackIota$1_ = ItemStackIota$1;
    class Advancement {
        constructor($$0: ResourceLocation_, $$1: Internal.Advancement_, $$2: Internal.DisplayInfo_, $$3: Internal.AdvancementRewards_, $$4: Internal.Map_<string, Internal.Criterion>, $$5: string[][], $$6: boolean)
        getRoot(): this;
        getCriteria(): Internal.Map<string, Internal.Criterion>;
        sendsTelemetryEvent(): boolean;
        addChild($$0: Internal.Advancement_): void;
        static getRoot($$0: Internal.Advancement_): Internal.Advancement;
        getParent(): this;
        getId(): ResourceLocation;
        getDisplay(): Internal.DisplayInfo;
        getRewards(): Internal.AdvancementRewards;
        deconstruct(): Internal.Advancement$Builder;
        getRequirements(): string[][];
        getChatComponent(): net.minecraft.network.chat.Component;
        getMaxCriteraRequired(): number;
        getChildren(): Internal.Iterable<Internal.Advancement>;
        get root(): Internal.Advancement
        get criteria(): Internal.Map<string, Internal.Criterion>
        get parent(): Internal.Advancement
        get id(): ResourceLocation
        get display(): Internal.DisplayInfo
        get rewards(): Internal.AdvancementRewards
        get requirements(): string[][]
        get chatComponent(): net.minecraft.network.chat.Component
        get maxCriteraRequired(): number
        get children(): Internal.Iterable<Internal.Advancement>
    }
    type Advancement_ = Advancement;
    interface SlidingDoorMode$IHasDoorMode {
        abstract railways$getSlidingDoorMode(): Internal.SlidingDoorMode;
        (): Internal.SlidingDoorMode_;
    }
    type SlidingDoorMode$IHasDoorMode_ = SlidingDoorMode$IHasDoorMode;
    interface RenderDataBlockEntity {
        getRenderData(): any;
        get renderData(): any
    }
    type RenderDataBlockEntity_ = RenderDataBlockEntity;
    class EntitySelector {
        constructor($$0: number, $$1: boolean, $$2: boolean, $$3: Internal.Predicate_<Internal.Entity>, $$4: any_, $$5: Internal.Function_<Vec3d, Vec3d>, $$6: Internal.AABB_, $$7: Internal.BiConsumer_<Vec3d, Internal.List<Internal.Entity>>, $$8: boolean, $$9: string, $$10: Internal.UUID_, $$11: Internal.EntityType_<any>, $$12: boolean)
        usesSelector(): boolean;
        static joinNames($$0: Internal.List_<Internal.Entity>): net.minecraft.network.chat.Component;
        findPlayers($$0: Internal.CommandSourceStack_): Internal.List<Internal.ServerPlayer>;
        findEntities($$0: Internal.CommandSourceStack_): Internal.List<Internal.Entity>;
        findSingleEntity($$0: Internal.CommandSourceStack_): Internal.Entity;
        includesEntities(): boolean;
        findSinglePlayer($$0: Internal.CommandSourceStack_): Internal.ServerPlayer;
        isWorldLimited(): boolean;
        isSelfSelector(): boolean;
        getMaxResults(): number;
        get worldLimited(): boolean
        get selfSelector(): boolean
        get maxResults(): number
        readonly predicate: Internal.Predicate<Internal.Entity>;
        static readonly ORDER_ARBITRARY: Internal.BiConsumer<Vec3d, Internal.List<Internal.Entity>>;
        static readonly INFINITE: 2147483647;
    }
    type EntitySelector_ = EntitySelector;
    abstract class PermissionCollection implements Internal.Serializable {
        constructor()
        setReadOnly(): void;
        elementsAsStream(): Internal.Stream<Internal.Permission>;
        abstract elements(): Internal.Enumeration<Internal.Permission>;
        abstract implies(arg0: Internal.Permission_): boolean;
        isReadOnly(): boolean;
        abstract add(arg0: Internal.Permission_): void;
        get readOnly(): boolean
    }
    type PermissionCollection_ = PermissionCollection;
    interface WorkMonitor {
        runWork(runnable: Internal.Runnable_): boolean;
        abstract shouldWork(): boolean;
        abstract trackWork(arg0: number, arg1: Internal.TimeUnit_): void;
        abstract canWork(): boolean;
    }
    type WorkMonitor_ = WorkMonitor;
    interface LongStream$Builder extends Internal.LongConsumer {
        andThen(arg0: Internal.LongConsumer_): Internal.LongConsumer;
        abstract build(): Internal.LongStream;
        add(arg0: number): this;
        abstract accept(arg0: number): void;
    }
    type LongStream$Builder_ = LongStream$Builder;
}
declare namespace io.netty.channel {
    interface Channel extends Internal.Comparable<io.netty.channel.Channel>, Internal.ChannelOutboundInvoker, io.netty.util.AttributeMap {
        abstract isWritable(): boolean;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract pipeline(): Internal.ChannelPipeline;
        abstract deregister(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract flush(): this;
        abstract eventLoop(): Internal.EventLoop;
        abstract isActive(): boolean;
        abstract parent(): this;
        abstract attr<T>(arg0: Internal.AttributeKey_<T>): io.netty.util.Attribute<T>;
        abstract unsafe(): Internal.Channel$Unsafe;
        abstract read(): this;
        abstract write(arg0: any): Internal.ChannelFuture;
        abstract writeAndFlush(arg0: any): Internal.ChannelFuture;
        abstract disconnect(): Internal.ChannelFuture;
        abstract compareTo(arg0: io.netty.channel.Channel_): number;
        abstract close(): Internal.ChannelFuture;
        abstract isOpen(): boolean;
        abstract write(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract bytesBeforeWritable(): number;
        abstract connect(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract remoteAddress(): Internal.SocketAddress;
        abstract metadata(): Internal.ChannelMetadata;
        abstract deregister(): Internal.ChannelFuture;
        abstract id(): Internal.ChannelId;
        abstract disconnect(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract localAddress(): Internal.SocketAddress;
        abstract newFailedFuture(arg0: Internal.Throwable_): Internal.ChannelFuture;
        abstract bytesBeforeUnwritable(): number;
        abstract alloc(): Internal.ByteBufAllocator;
        abstract close(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract newSucceededFuture(): Internal.ChannelFuture;
        abstract isRegistered(): boolean;
        abstract newProgressivePromise(): Internal.ChannelProgressivePromise;
        abstract closeFuture(): Internal.ChannelFuture;
        abstract bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract writeAndFlush(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract bind(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract config(): Internal.ChannelConfig;
        abstract hasAttr<T>(arg0: Internal.AttributeKey_<T>): boolean;
        abstract voidPromise(): Internal.ChannelPromise;
        abstract newPromise(): Internal.ChannelPromise;
        get writable(): boolean
        get active(): boolean
        get open(): boolean
        get registered(): boolean
    }
    type Channel_ = Channel;
}
